/* - StepperVelocityListener -
 * Display the data from the velocity change event
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.StepperVelocityChangeListener;
import com.phidgets.event.StepperVelocityChangeEvent;

import javax.swing.JComboBox;
import javax.swing.JTextField;
/**
 *
 * @author Owner
 */
public class StepperVelocityListener implements StepperVelocityChangeListener{
    
    private JComboBox motorCmb;
    private JTextField velTxt;
    
    /**
     * Creates a new instance of StepperVelocityListener
     */
    public StepperVelocityListener(JComboBox motorCmb, JTextField velTxt)
    {
        this.motorCmb = motorCmb;
        this.velTxt = velTxt;
    }

    public void stepperVelocityChanged(StepperVelocityChangeEvent stepperVelocityChangeEvent)
    {
        if(stepperVelocityChangeEvent.getIndex() == ((Integer)motorCmb.getSelectedItem()).intValue())
        {
            velTxt.setText(Double.toString(stepperVelocityChangeEvent.getValue()));
        }
    }
    
}
